//
//  MCQueryElementSubView.h
//  MCApplication
//
//  Created by Michael Clark on 10/09/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCView.h"


@class MCQueryCriteria;
@class MCQueryValueView;
@class MCPDocument;

@interface MCQueryElementSubView : MCView {
	IBOutlet NSButton*            minusButton;
	IBOutlet NSPopUpButton*       operatorPopUp;
	IBOutlet NSArrayController*   operatorController;
	IBOutlet NSBox*               valuePlaceholder;
	
	MCQueryValueView*             valueView;
	
	NSDictionary*                 selectedOperator;
	
	MCQueryCriteria*       _criteria;
	NSDictionary*          _config;
	NSMutableDictionary*   _valuesCache;
	
	NSRect     _minusButtonRect;
	int        _minusButtonImageIndex;
	
	BOOL       _isMinusButtonDisabled;
	BOOL       _hideOperatorPopUp;
	
//	MCPDocument*   __document;
}

- (NSDictionary*)viewConfig;


- (IBAction)deleteSubElement: (id)sender;

- (void)enableMinusButton;
- (void)disableMinusButton;

- (MCQueryCriteria *)criteria;
- (void)setCriteria:(MCQueryCriteria *)aCriteria;

- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (NSDictionary *)selectedOperator;
- (void)setSelectedOperator:(NSDictionary *)aSelectedOperator;

//- (MCPDocument *)document;
//- (void)setDocument:(MCPDocument *)aDocument;

@end
